library(rgdal)


# Open file to receive the various plots
pdf(file="../results/boatslips_2017sample.pdf", family="Palatino")


# Read existing boat slip file
allslips <- read.table(file="../data/allboatslips.txt", header=TRUE, sep="\t")
coordinates(allslips)<- ~ Longitude + Latitude
proj4string(allslips)<-CRS("+init=epsg:4326")
allslips <- spTransform(allslips, CRS("+init=epsg:2893"))
df0 <- data.frame(allslips@coords)

# generate a simple map
plot(df0, axes=TRUE, pch=21, cex=0.1, col="green")



# A sample of the digitized boat slip locations by the 2017 method
data <- read.table ("../data/sample_boat_slips.txt", skip=1, header=FALSE, sep="\t")
str(data)

# Assign names to the columns
names(data) <- c("Longitude", "Latitude", "Level", "UTM-Easting", "UTM-Northing", "Section")

# Define as spatial objects: X and Y stand for the name of the lon/lat columns 
coordinates(data)<- ~ Longitude + Latitude

# The coordinates are in WGS 84 -> 4326
proj4string(data)<-CRS("+init=epsg:4326")
# See: http://www.geotoolkit.org/modules/referencing/supported-codes.html for coordinates codes
# See also: http://www.epsg-registry.org/

head(data)
class(data)


# FIPS (SPCS ID) 1900 -> EPSG ID 26985 (m) -> 2893 (ft)
# http://www.eye4software.com/resources/stateplane/
boatslips <- spTransform(data, CRS("+init=epsg:2893"))
str(boatslips)
df1 <- boatslips@coords
str(df1)
df2 <- data.frame(boatslips@coords)
str(df2)

x <- df2$Longitude
y <- df2$Latitude
points(x, y, pch=20, cex=0.05, col="red")


# Compute a bounding box for the small data set, then find all that are within it
# of the large set
xmin <- min(x)
ymin <- min(y)
xmax <- max(x)
ymax <- max(y)

# Make the bounding box 50% larger
dx <- 0.25 * (xmax - xmin)
dy <- 0.25 * (ymax - ymin)
xmin <- xmin - dx
xmax <- xmax + dx
ymin <- ymin - dy
ymax <- ymax + dy
xmin
xmax
ymin
ymax

df1 <- df0
df1 <- df1[df1[,1]>xmin, ]
df1 <- df1[df1[,1]<xmax, ]
df1 <- df1[df1[,2]>ymin, ]
df1 <- df1[df1[,2]<ymax, ]
str(df1)
plot(df1, col="green", pch=19, cex=1.5)
points(df2, col="red", pch=3, cex=1.5)
grid(col="black")
legend(648500, 691200, legend=c("From Complete Set", "2017 Subset"), col=c("green", "red"), pch=c(21, 3))
title(main="Comparing Boatslips from 6/3/2011 and 9/5/2013")

# class(boatslips)			# Identifies the class of the object
# str(boatslips)				# Returns the structure of an object
# dimensions(boatslips)
# #coordinates(boatslips)
# data <- SpatialPoints(boatslips)
# class(data)
#
# plot (data, col="green")
#
# # boatslipframe <- SpatialPoints(signature(from="SpatialPoints", to="data.frame"))
# objects()
#
# bbox(boatslips)
# #proj4string(boatslips)
# #head(boatslips)
# #coordinates(boatslips)
#
# attributes(boatslips)
 
dev.off()
