# docks.R
# 9/18/2017

library(rgdal)

pdf(file="../results/boatslips.pdf", family="Palatino")

# Shoreline data
shoreline <- read.table(file="../data/century2462.txt", header=TRUE, sep="\t")

# Boat slip data
docks.rg <- readOGR("../data/DCL_Docks", "DCL_Docks")
slips <- data.frame(docks.rg@coords)

# Generate a simple map
plot(shoreline, axes=TRUE, type="l", lwd=0.5)
points(slips, pch=19, cex=0.1, col="green")
grid(col="black")
title(main="All 2011 Boat Slips\nBlack line is shoreline; green dots are boat slips")

dev.off()
