# delta_lakelevel.R
# Also used by: wrapper_delta_lakelevel.R
# 11/13/2017
# PLV

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# library(extrafont)
#
# #========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# year <- 2012
#
# #========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# file1 <- paste("../results/", year, "_delta_lakelevels.pdf", sep="")
# pdf(file1, family="Centurion", width=6, height=4.5)


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# REF: https://www.r-bloggers.com/doing-away-with-%E2%80%9Cunknown-timezone%E2%80%9D-warnings/
Sys.setenv(TZ="America/New_York")
Sys.getenv("TZ")

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
source("../functions/credit.R")

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
file2 <- paste("../data/", year, "_daily_lakelevels.txt", sep="")
df <- read.table(file=file2, header=TRUE, sep="\t")
str(df)

day.of.year <- df[ ,1]
lake.level  <- as.numeric(df[ ,2])
lake.rain   <- as.numeric(df[ ,3])
level.lrb   <- as.numeric(df[ ,4])

day.of.year <- as.POSIXct(as.character(day.of.year), format="%m/%d/%Y", tz="" )

delta.level <- 12.0 * (lake.level - level.lrb)
head(delta.level)

y.max <- max(delta.level)
y.min <- min(-5, min(delta.level))
main.text <- paste("Delta Lake Level and LRB\n", "Year = ", year, sep="")
x.lab <- "Day of the Year"
y.lab <- "Delta Lake Level, inches"
plot(day.of.year, delta.level, type="o",
     ylim= c(y.min, y.max),
	 main=main.text, cex=0.3,
	 xlab=x.lab, ylab=y.lab)
grid(col="black")
abline(h=0, lwd=3, col="red")
credit("delta_lakelevel.R")
#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

# dev.off()

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
