# wrapper_delta_lakelevel.R
# 11/13/2017
# PLV

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Wrapper for doing all years of lake level data

# REF: http://blog.revolutionanalytics.com/2012/09/how-to-use-your-favorite-fonts-in-r-charts.html
library(extrafont)

names.years <- c(1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016)
names.years
nyrs <- length(names.years)
seqn.id <- c("a", "b", "c", "d", "e", "f")

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# file1 <- paste("../results/delta_lakelevels.pdf", sep="")
# # pdf(file1, family="Centurion", width=6, height=4.5)
# pdf(file1, family="Centurion", onefile=TRUE)

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

n2 <- 3
n1 <- as.integer(length(names.years) / n2) + 1
n1
n2
par(mfrow=c(n1, n2))
par(mfrow=c(3, 3))

nplots <- 9
page <- 0
for(i in 1:nyrs){
	resid <- (i-1) %% nplots
	print(resid)
	if(resid == 0) {
		dev.off()
		page <- page + 1
		file1 <- paste("../results/delta_lakelevels_", seqn.id[page], ".pdf", sep="")
		print(file1)
		print(seqn.id[page])
		pdf(file1, family="Centurion", onefile=TRUE)
		par(mfrow=c(3, 3))
	}
	year <- names.years[i]
	print(year)
	source("./delta_lakelevel.R")
}

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

dev.off()

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
