# FILE: ThreePointsCircle.R
# REF: https://math.stackexchange.com/questions/2836274/3-point-to-circle-and-get-radius

# See also: http://www.ambrsoft.com/trigocalc/circle3d.htm
# https://math.stackexchange.com/questions/213658/get-the-equation-of-a-circle-when-given-3-points
#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

prob <- 1 #Sample Problem 1
xpoints <- c( 1, 2, 5 )
ypoints <- c( 1, 4, 3 )

# prob <- 2 #Sample Problem 2
# xpoints <- c(0.0, 1500.0, 1387.5)
# ypoints <- c(0.0000,  0.0000, 569.9507)

# prob <- 3 #Sample Problem 3
# xpoints <- c(6900, 7050, 7550)      # NOTE: This sample is solved correctly!
# ypoints <- c(4600, 5500, 5700)      # NOTE: This sample is solved correctly!

print(paste("Sample Problem # ", prob, sep=""))
print("x coordinates")
xpoints
print("y coordinates")
ypoints

# All plots will be collected in this pdf file
pdf(paste("../results/circle_", prob, ".pdf", sep=""), onefile=TRUE)


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

threePointToCircle  <- function(xpoints, ypoints){

    x1 <- xpoints[1]
    x2 <- xpoints[2]
    x3 <- xpoints[3]

    y1 <- ypoints[1]
    y2 <- ypoints[2]
    y3 <- ypoints[3]

    dx2 <- x2 - x1
    dx3 <- x3 - x1
    dy2 <- y2 - y1
    dy3 <- y3 - y1

    xtop <- dx2 * dx2 * dy3  -  dx3 * dx3 * dy2  +  dy2 * dy2 * dy3  -  dy3 * dy3 * dy2
    xbot <- 2.0 * (dx2 * dy3 - dx3 * dy2)

    xc <- x1 + xtop / xbot


    ytop <- dx2 * dx2 * dx3  -  dx3 * dx3 * dx2  +  dy2 * dy2 * dx3  -  dy3 * dy3 * dx2
    ybot <- 2.0 * (dx3 * dy2 - dx2 * dy3)

    yc <- y1 + ytop / ybot

    xx <- xc - x1
    yy <- yc - y1

    r <- sqrt(xx * xx + yy * yy)

    return(c(xc, yc, r))
}


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Calling the function with the data and returning the results in a vector 'z'

z <- threePointToCircle(xpoints, ypoints)
print('Center-x, Center-y, Radius')
z 
xc <- z[1]
yc <- z[2]
radius <- z[3]


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# The following is all about plotting the results
library(plotrix)

# Define the plot region
x0 <- c(xc - 1.2 * radius, xc + 1.2 * radius)
y0 <- c(yc - 1.2 * radius, yc + 1.2 * radius)
plot(x0, y0)

# Draw the circle
draw.circle(xc, yc, radius, nv=50, border=NULL, col=NA, lty=1, lwd=1)

# Show the points
points(xpoints,ypoints)

# Show the center
points(xc, yc, cex=2, pch=1)

# Add a grid
grid(col="black")


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Echo check to make sure the the radius to the points is the same for all points
print("Echo check of points being on the circle")
for(i in 1:3){
    print(sqrt((xc - xpoints[i])^2 + (yc - ypoints[i])^2))
}


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Creating my own circle
cx <- vector()
cy <- vector()
alfa <- 0
n <- 100
da <- 2*pi / n
for(i in 1:n){
    cx[i] <- xc + radius * cos(alfa)
    cy[i] <- yc + radius * sin(alfa)
    alfa <- alfa + da
}
cx[n+1] <- cx[1]
cy[n+1] <- cy[1]


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Plot my own circle
plot(x0, y0)
points(cx, cy, pch=20, col="red", cex=0.5, type="l")
points(xpoints,ypoints)
points(xc, yc, cex=2, pch=1)
grid(col="black")




#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Calculate the lengths of the three sides of the triangle
# Sample Data
print("Compute the lengths of the three sides of the triangle")
x <- xpoints
y <- ypoints

print("x coordinates")
x
print("y coordinates")
y


# Refer to Figure 1 for notation

c <- sqrt( ( x[2] - x[1] ) ^ 2 + ( y[2] - y[1] ) ^ 2 ) 
c <- round(c, digits=4)

b <- sqrt( ( x[3] - x[2] ) ^ 2 + ( y[3] - y[2] ) ^ 2 ) 
b <- round(b, digits=4)

a <- sqrt( ( x[3] - x[1] ) ^ 2 + ( y[3] - y[1] ) ^ 2 ) 
a <- round(a, digits=4)

print(paste("lengths <- c(", c, ", ",  b, ", ",  a, ")", sep=""))



# Close the pdf file
dev.off()

