# tp_contours.R


library(fields)	 # For image.plot 
library(akima)	 # Akima interpolation
library(rgeos)   # setdiff()
library(MBA)     # MBA interpolation
library(raster)	 # For raster 
library(ggplot2) # For fortify


library(tgp)	 # For interp.loess 
library(sp)      # For spatial representation 

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

source("../functions/hole_in_frame.R")

#================================================================ 
pdf(file="../results/contour_creation.pdf", onefile=TRUE)

#================================================================ 
# Definition of the polygon to approximate the shape of a cove

x <- c(47, 44, 33, 20,19,30,16,4,16,34,45,52,60,60, 47) 
y <- c(0,13,20,20,24,30,37,42,45,40,28,20,25,0, 0) 
z <- seq(0, 0, length=length(x)) 

plot(x, y, main="Figure 1. Simple polygon", type="b")


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Definition of irregularly spaced -z- values inside the contour

xx <- c(48,44,33,25,22,30,16,12,16,34,46,52,58,58,32,52) 
yy <- c(1,14,22,22,22,28,38,42,43,36,21,18,20,4,30,12) 
zz <- c(5, 6, 6, 4, 7, 5, 4, 3, 5, 6 ,8, 9, 6, 3, 5, 9)

plot(x, y, type="b", main="Figure 2. Simple polygon with irregularly spaced values (2-D).")
points(xx, yy, pch=19, col="red")


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Definition of the bounding box, grid, cove outline and mask

# Define the extent
xmin <- min(x) 
xmax <- max(x) 
ymin <- min(y) 
ymax <- max(y) 
xbox <- c(xmin, xmax, xmax, xmin) 
ybox <- c(ymin, ymin, ymax, ymax) 

# Define the data set for interpolation (add the boundaries = 0.0)
xxx <- c(x, xx)
yyy <- c(y, yy)
zzz <- c(z, zz)

# Define the grid
dxy <- 0.2 
nx <- (xmax-xmin)/dxy 
ny <- (ymax-ymin)/dxy 
x0 <- seq(xmin, xmax, length = nx) 
y0 <- seq(ymin, ymax, length = ny) 

# Define the mask that removes extraneous materials from the desired plot.
# Make the bounding box a closed polygon data item and put in dataframe
xxpoly <- c(xbox, xbox[1]) 
yypoly <- c(ybox, ybox[1])
q1 <- data.frame(xxpoly, yypoly)

# Make the cove boundary a closed polygon data item and put in dataframe
xpolycove <- c(x, x[1]) 
ypolycove <- c(y, y[1]) 
q2 <- data.frame(xpolycove, ypolycove)

# Define the mask
q3 <- hole_in_frame(q1, q2)
# To use q3: polygon(q3[[1]], q3[[2]], col="grey") # Any color

# str(q3)
# q3[[1]]
# q3[[2]]

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Do the Akima interpolation/smoothing 

# Interpolate
akima <- interp(xxx, yyy, zzz, xo=x0, yo=y0, duplicate="strip")
# Plot interpolation
image.plot(akima) 
# Add exterior contour
polygon(x, y, lwd=4)
# Show data points used
points(xx,yy, pch=19, col="white")
# Make contours
contour(akima$x, akima$y, akima$z, add=TRUE, labcex=1.2)
# Add title to plot
title("Figure 3. Akima and image.plot and contour") 


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Replot the Akima results

image.plot(akima)
# Add exterior contour
polygon(x, y, lwd=4)
# Show data points used
points(xx,yy, pch=19, col="white", type="n")
# Make contours
contour(akima$x, akima$y, akima$z, add=TRUE, labcex=1.2)
# Add title to plot
title("Figure 4. Akima and clean image.plot and contours") 
# Mask unwanted stuff
polygon(q3[[1]], q3[[2]], col="grey") # Any color


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Data in spatial representation 

# Closed spatial polygon of the cove outline
xpolycove <- c(x, x[1]) 
ypolycove <- c(y, y[1]) 
xycove <- cbind(xpolycove, ypolycove) 
xypolycove <- Polygon(xycove, hole=TRUE) 
plot(xpolycove, ypolycove, main="Figure 5. Spatial cove outline polygon", type="b", col="purple")
sss1 <- Polygons(list(xypolycove), "s1")


xxpoly <- c(xbox, xbox[1]) 
yypoly <- c(ybox, ybox[1])
plot(xxpoly, yypoly, main="Figure 6. Spatial box polygon", type="b", col="purple")


# Define the map area polygon 
maparea <- cbind(xxpoly, yypoly) 
mappoly <- Polygon(maparea) 
sss2    <- Polygons(list(mappoly), "s2") 

SpP = SpatialPolygons(list(sss2, sss1), 1:2) 
xa <- raster(akima) 
ya <- mask( xa, SpP[2] ) 
plot(ya, main="Figure 7. Masked area if this works")


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

# REF: http://r-sig-geo.2731867.n2.nabble.com/Clearing-the-area-outside-of-a-polygon-defined-on-a-grid-td7581718.html

# OTHER REFERENCES...
# https://philmikejones.wordpress.com/2015/09/01/clipping-polygons-in-r/
# https://gis.stackexchange.com/questions/109639/how-to-reverse-clip-erase-in-r
# https://gis.stackexchange.com/questions/140504/extracting-intersection-areas-in-r
# http://www.alisonsinclair.ca/2011/03/shading-between-curves-in-r/

# MBA Interpolation - raw version

df <- data.frame(xxx, yyy, zzz)
# mba interpolation
mba <- mba.surf(df, nx, nx)$xyz.est
# Plot the resuts
image.plot(mba, xlim = extendrange(xbox), ylim = extendrange(ybox),
	  lwd=0.05, lty=3, xlab="Easting (ft)", ylab="Northing(ft)")
# Show the data points used
points(xx,yy, pch=19, col="white", type="p")
# Make contours
contour(mba, add=TRUE, labcex=0.7, drawlabels=TRUE)     # contours
# Add title to plot
title("Figure 8. MBA and raw image.plot and contours") 


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# # Overlay the two polygons, subtracting the cove from the bounding box
# plot(setdiff(p1, p2), poly.args = list(col = "grey"), add=TRUE)


# MBA Interpolation - clean version
image.plot(mba, xlim = extendrange(xbox), ylim = extendrange(ybox),
	  lwd=0.05, lty=3, xlab="Easting (ft)", ylab="Northing(ft)")
# Add exterior contour
polygon(x, y, lwd=4)
# Show data points used
points(xx,yy, pch=19, col="white", type="p")
# Make contours
contour(mba, add=TRUE, labcex=0.7, drawlabels=TRUE)     # contours
# Add title to plot
title("Figure 9. MBA and clean image.plot and contours") 
# Overlay the two polygons, subtracting the cove from the bounding box
# plot(setdiff(p1, p2), poly.args = list(col = "grey"), add=TRUE)
str(q3)
polygon(q3[[1]], q3[[2]], col="grey")  # Uses results of "hole_in_frame"


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
plot(q3, type="l", col="red", lwd=5)
polygon(q3[[1]], q3[[2]], col="grey")  # Uses results of "hole_in_frame"
title(main="Figure 10. Double check on homegrown masking technique")


dev.off()

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Retrieve contour lines in digital form

library(maptools)
x2 <- ContourLines2SLDF(contourLines(mba))
summary(x2)
x2

# http://grokbase.com/t/r/r-sig-geo/093kmnkrs3/extract-coordinates-from-spatialpolygonsdataframe
# Hadley Wickam: I have the following code in ggplot2 for turning a SpatialPolygon into
# a regular data frame of coordinates. You'll need to load ggplot2, and then run fortify(yoursp).
df <- fortify(x2)    # Requires 'ggplot2'
str(df)

dC1 <- df[df$id=="C_1",]
str(dC1)

library(broom)
df <- tidy(x2)
str(df)
dC1 <- df[df$id=="C_1",]
str(dC1)

x5 <- contourLines(mba)
# str(x5)
x <- x5[[1]][["x"]]
y <- x5[[1]][["y"]]
level <- x5[[1]][["level"]]
level


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
pdf(file="../results/arrowhead_areas.pdf", onefile=TRUE)

# library(sos)
# findFn("area polygon compute")
#
# library(secr)
# polyarea(dC1)

m1 <- x5[[1]]
str(m1)


x5 <- contourLines(mba)

library(splancs)

carea <- vector()
clevl <- vector()
nc <- length(x5)
nc

for(i in 1:nc){
	m1 <- x5[[i]]
	clevel <- m1$level
	unlist(m1)
	m <- cbind(m1$x,m1$y)
	area <- with(x5[[i]],areapl(cbind(x,y)))
	maintext <- paste("Area of polygon = ", signif(area, 3), "  contour level = ", clevel, sep="")
	# print(paste(i, area, clevel), sep="     ")
	plot(m, type="b", main=maintext)
	carea[i] <- area
	clevl[i] <- clevel
}
dflevel <- data.frame(clevl, carea)
aggregate(carea ~ clevl, data=dflevel, FUN=sum)

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

# Creating DEMs from contour lines using R
# https://chitchatr.wordpress.com/2014/03/15/creating-dems-from-contour-lines-using-r/
# https://stackoverflow.com/questions/8406507/how-can-i-calculate-the-area-within-a-contour-in-r
# http://adv-r.had.co.nz/OO-essentials.html


# x <- findFn(string = 'area polygon compute')


x5 <- contourLines(mba)  # Defines the contours

library(splancs)  # Needed for the function 'areapl'

carea <- vector()   # initialize
clevl <- vector()   # initialize
nc <- length(x5)    # Number of contour sets

for(i in 1:nc){
	m1 <- x5[[i]]       # Extracts a contour data set
	clevel <- m1$level  # Determines the level it belongs to
	unlist(m1)          # Converts from 'list' to 'numeric'
	clevl[i] <- m1$level    # Extracts the 'level'
	carea[i] <- with(x5[[i]],areapl(cbind(x,y)))   # Computes the area
}
dflevel <- data.frame(clevl, carea)  # Converts to a dataframe

 # Sums the values for each level; levels are defined in the contour plot
aggregate(carea ~ clevl, data=dflevel, FUN=sum)

# Simple plotted as
plot(clevl, carea, type="h", lwd=10)


dev.off()

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0



