# The following function determined whether a dataframe of x any is clockwise or counter-clockwise
# If the result is positive, it is clock-wise.  If it's negative it's counter clock-wise
# REF: https://stackoverflow.com/questions/1165647/how-to-determine-if-a-list-of-polygon-points-are-in-clockwise-order
# Assumes Cartesian coordinates
# Formula only works for CLOSED polygons.
# Requires package "sp"
# Usage:
# 1) Define two polygons with x/y coordinates, q1 and q2, where q1 is the hole
# 2) Call: q3 <- q3 <- hole_in_frame(q1, q2)
# 3) Make sure to have loaded 'library(sp)'
# 4) After plotting interpolated output: polygon(q3[[1]], q3[[2]], col="grey") # Any color

point_order <- function(dff){
	x <- dff[[1]]
	y <- dff[[2]]
	n <- length(x)
	sum <- 0
	for(i in 2:n){
		sum <- sum + (x[i]-x[i-1])*(y[i]+y[i-1])
	}
	sum
}

hole_in_frame <- function(df1, df2){
	# Force the names of the two dataframes to be the same
	q1 <- df1
	names(q1) <- c("X", "Y")
	q2 <- df2
	names(q2) <- c("X", "Y")
	s1 <- point_order(q1)
	s2 <- point_order(q2)
	# If TRUE we have to reverse one of the data sets
	if(s1 > 0 && s2 > 0 || s1 < 0 && s2 < 0) {
		q1 <- q1[order(nrow(q1):1), ]    #invert row order
	}
	q2 <- rbind(q2, q1[nrow(q1),])
	# We now put the two dataframes together
	q3 <- rbind(q1, q2)
	return(q3)
}
