# This exercise is about checking out the validity of the interpolations
#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

# Define the color palette
palette(c("#FF0000", "#FF7100", "#FFAA00", "#FFE300", "#4cff00", "#41de00",  "#32ab00", "#00FFE3", "#00E3FF", "#00AAFF", "#0071FF", "#3900FF"))
levelcolors <- palette()
colorbreaks <- c(0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 50, 100)
ncolors <- length(colorbreaks)-1
length(levelcolors)
length(colorbreaks)

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# A bar plot of the palette
barplot(colorbreaks[2:length(colorbreaks)],col=palette(), names.arg=colorbreaks[2:length(colorbreaks)])


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# The value 'n' can be changed.  It's the number of points to be plotted.
n <- 20


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
interval <- 100
set.seed(30323)
# Ref: http://blog.revolutionanalytics.com/2009/02/how-to-choose-a-random-number-in-r.html
x <- runif(n, 1, 100)
x
y <- runif(n, 1, 100)
y
z <- rexp(n)
z <- abs(rnorm(n))
z <- 100.0*z/max(z)
zz <- sort(z)
zz

bpts <- seq(0, 100, by=10)
bpts

nz <- length(z)
hist(z, col=palette(), breaks=bpts)


CEX=1.5
#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
colorbreaks <- c(0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 50, 100)

# Apply color palette indices to the z values
colors <- sapply(z,function(x)which.min(abs(x - colorbreaks)))
colors
z
colorbreaks
1:length(colorbreaks)

# Plot points only
xyz <- cbind(x, y, z)
plot(xyz, col=colors, pch=19, cex=CEX, xlim=c(0,100), ylim=c(0,100))
points(x, y, pch=21, cex=CEX)
# Add a grid
grid(lwd=3, col="black")
# http://www.dummies.com/how-to/content/how-to-round-off-numbers-in-r.html
text(x+7,y,signif(z, digits=2), cex=CEX)



#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Akima Linear interpolation
library(akima)
# Linear
akima <- interp(x,y,z, duplicate="mean", xo=seq(1, 100, 2), yo=seq(1, 100, 2))
image(akima, col=levelcolors, breaks=colorbreaks, xlim=c(0,100), ylim=c(0,100))
grid(lwd=3, col="black")
contour(akima, labcex=1.5, levels=colorbreaks, add=TRUE, col="white", lwd=2)
title(paste("Akima - Linear - using ", nz, " data points"))
points(x, y, pch=21, bg=colors, lwd=2, cex=CEX)

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# Akima Spline interpolation
akima <- interp(x,y,z, duplicate="mean", linear=FALSE,  xo=seq(1, 100, 2), yo=seq(1, 100, 2))
image(akima, col=levelcolors, breaks=colorbreaks, xlim=c(0,100), ylim=c(0,100))
grid(lwd=3, col="black")
contour(akima, labcex=1.5, levels=colorbreaks, add=TRUE, col="white", lwd=2)
title(paste("Akima - Spline - using ", nz, " data points"))
points(x, y, pch=21, bg=colors, lwd=2, cex=CEX)


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
# MBA Interpolation

library(MBA)
nx <- 50
s <- data.frame(x, y, z)
mba <- mba.surf(s, nx, nx, h=ncolors)$xyz.est
image(mba, col=levelcolors, breaks=colorbreaks, xlim=c(0,100), ylim=c(0,100))
grid(lwd=3, col="black")
contour(mba, labcex=1.5, levels=colorbreaks, add=TRUE, col="white", lwd=2)
title(paste("MBA -  using ", nz, " data points"))
points(x, y, pch=21, bg=colors, lwd=2, cex=CEX)

library(maptools)
x2 <- ContourLines2SLDF(contourLines(mba))
summary(x2)
x2

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
